import java.util.*;
import java.io.*;

class SegmentationExperiment extends InfiniteExemplarModelExperiment {
    
    /*****************************************************************/
    /*                            Methods                            */
    /*****************************************************************/

    /**
     * By default, read parameters from "experiment_parameters.txt".
     */
    public SegmentationExperiment(String parameterFile) {
	super(parameterFile);
	
    }

    /**
     * Filename portion for dataset-specific parameters
     */
    public String BaseFilename() {
	int instance = 0;
	String filename = dataset_;

	return filename;
	// Never overwrite results, even if we have the same
	// settings for all parameters.
	// while (true) {
	//    File f = new File(fullName + instance + ".txt");
	//    if (!f.exists()) break;
	//}

    }

    public String ResultsFilename() {
	return "/u/dtarlow/workspace/superpixels/" + BaseFilename() + "_res.txt";
    }

    public String PointsFilename() {
	assert false : "No points for images";
	return "data/" + BaseFilename() + "_points.txt";
    }

    public String SimilaritiesFilename() {
	return "/u/dtarlow/workspace/superpixels/" + BaseFilename() + "_sims.txt";
    }

    public String TrueLabelsFilename() {
	assert false : "No true labels for images";
	return "data/" + BaseFilename() + "_labels.txt";
    }

    /*****************************************************************/
    /*                              Main                             */
    /*****************************************************************/

    public static void main(String args[]) {
	InfiniteExemplarModelExperiment e = 
	    new SegmentationExperiment(args[0]);

	e.RunExperiments();

	e.WriteResultsToCSV(args[1]);

	e.DisplayResults();

    }
    

}
